<?php
namespace Optimize\Modules\PricingTables;

use Optimize\Modules\Shortcodes\Lib\ShortcodeInterface;

class PricingTables implements ShortcodeInterface {
	private $base;

	function __construct() {
		$this->base = 'mkdf_pricing_tables';
		add_action('vc_before_init', array($this, 'vcMap'));
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {

		vc_map(array(
			'name' => esc_html__( 'Pricing Tables', 'mikado-core' ),
			'base'                    => $this->base,
			'as_parent'               => array('only' => 'mkdf_pricing_table'),
			'content_element'         => true,
			'category' => esc_html__( 'by MIKADO', 'mikado-core' ),
			'icon'                    => 'icon-wpb-pricing-tables extended-custom-icon',
			'show_settings_on_create' => true,
			'params'                  => array(
				array(
					'type'        => 'dropdown',
					'holder'      => 'div',
					'class'       => '',
					'heading' => esc_html__( 'Columns', 'mikado-core' ),
					'param_name'  => 'columns',
					'value'       => array(
						esc_html__('Two', 'mikado-core' )   => 'mkdf-two-columns',
						esc_html__('Three', 'mikado-core' ) => 'mkdf-three-columns',
						esc_html__('Four', 'mikado-core' )  => 'mkdf-four-columns',
					),
					'save_always' => true,
					'description' => ''
				)
			),
			'js_view'                 => 'VcColumnView'
		));

	}

	public function render($atts, $content = null) {
		$args = array(
			'columns' => 'mkdf-two-columns'
		);

		$params = shortcode_atts($args, $atts);
		extract($params);

		$html = '<div class="mkdf-pricing-tables clearfix '.$columns.'">';
		$html .= do_shortcode(preg_replace('#^<\/p>|<p>$#', '', $content));
		$html .= '</div>';

		return $html;
	}

}
